<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function lines()
    {
        return $this->morphMany('App\Models\Finance\Line', 'lineable');
    }

    public function customer()
    {
        return $this->belongsTo('App\Models\Person\Person', 'customer_id');
    }

    public function supplier()
    {
        return $this->belongsTo('App\Models\Person\Person', 'supplier_id');
    }

    public function accepted_by_person()
    {
        return $this->belongsTo('App\Models\Person\Person', 'accepted_by_person_id');
    }

    public function cancelled_by_person()
    {
        return $this->belongsTo('App\Models\Person\Person', 'cancelled_by_person_id');
    }

}